//
//  MCAccessClient.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-19.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCNetComm/MCClientEndpoint.h>

#import <MCClientServer/MCClientServerDefines.h>


@interface MCAccessClient : MCClientEndpoint {

	BOOL readyToSend;
    NSDictionary *lastAuthResponsePayload; // we need this because we are now passing more info and we may need access to this info.
}

@property (retain) NSDictionary *lastAuthResponsePayload;

- (void)getDatabaseList;
- (void)sendInfoRequest;

- (void)authorizeRequestToDatabase:(NSString *)databaseName
					 schemaVersion:(NSUInteger)schemaVersion
						  username:(NSString *)username
						  password:(NSString *)password
						clientUUID:(NSString *)clientUUID;

- (void)authorizeRequestToDatabase:(NSString *)databaseName
					 schemaVersion:(NSUInteger)schemaVersion
						  username:(NSString *)username
						  password:(NSString *)password;

- (void)authorizeRequestToDatabase:(NSString *)databaseName
					 schemaVersion:(NSUInteger)schemaVersion
						  username:(NSString *)username
						  password:(NSString *)password
						clientUUID:(NSString *)clientUUID
					  cloudAccount:(NSString *)cloudAccount;

/*!
 Use userInfo to send arguments than can help with optimizations. For instance, with BP, we can send the sync date, replica ID extra and if the server responds to that, it can send back whether a real connection needs to be made.
 */
- (void)authorizeRequestToDatabase:(NSString *)databaseName
					 schemaVersion:(NSUInteger)schemaVersion
						  username:(NSString *)username
						  password:(NSString *)password
						clientUUID:(NSString *)clientUUID
					  cloudAccount:(NSString *)cloudAccount
                          userInfo:(NSDictionary *)userInfo;

+ (MCAccessClient *)accessClientWithDelegate:(id)object hostAddresses:(NSArray *)addresses port:(unsigned short)hostPort;

#if defined TARGET_OS_MAC && ! TARGET_IPHONE_SIMULATOR
+ (NSString *)preferredAddressFromDatabaseAddresses:(NSArray *)dbAddresses serviceAddress:(NSString *)accessAddress;
#endif

@end

@interface NSObject (MCAccessClientDelegate)

- (void)accessClient:(MCAccessClient *)client receivedDatabaseList:(NSArray *)databaseDicts;
- (void)accessClient:(MCAccessClient *)client databaseListFailedWithResult:(MCSDatabaseListResultCode)result;

- (void)accessClient:(MCAccessClient *)client gotServerDetails:(NSDictionary *)details;

- (void)accessClient:(MCAccessClient *)client authorizationFailedWithResult:(MCSAuthorizationResultCode)result;
- (void)accessClient:(MCAccessClient *)client authorizationSucceededReturningInfo:(NSDictionary *)infoDict;

@end
